#!/bin/bash

# Copyright (c) 2005 Gentoo Foundation.
# $Id: multilib.bash.in 370 2007-06-16 22:18:30Z kugelfang $
# This file is part of the 'eselect' tools framework.
#
# eselect is free software; you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any later
# version.
#
# eselect is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# eselect; if not, write to the Free Software Foundation, Inc., 59 Temple
# Place, Suite 330, Boston, MA  02111-1307  USA

ES_VALID_MULTILIB_DIRS="lib lib32 lib64"

# list_libdirs PUBLIC
# Returns a space separated list of libdirs available on this machine
list_libdirs() {
    local dir libdirs
    libdirs=""
    for dir in ${ES_VALID_MULTILIB_DIRS} ; do
        if grep -q "^/${dir}\(\|/\)$" ${ROOT}/etc/ld.so.conf &> /dev/null ; then
            libdirs=( ${libdirs[@]} ${dir} )
        fi
    done
    if [[ -z ${libdirs[@]} ]] ; then
    	# Broken or non-existing ld.so.conf
    	libdirs=( ${ROOT}/lib* )
	libdirs=( ${libdirs[@]/\/lib/lib} )
    fi
    echo "${libdirs[@]}"
}

# vim: set sw=4 et sts=4 tw=80 :
