/*
 * Linux 2.6(+) RAID Autostarter
 *
 * Copyright (C) 2005 by Tim Yamin <plasmaroo@gentoo.org> <plasm@roo.me.uk>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <linux/major.h>
#include <linux/raid/md_u.h>

extern int
mdstart_main(int argc, char *argv[])
{
	int i, fd, part = 0, retval = 0;

	if(argc < 2)
	{
		bb_show_usage();
	}

	for(i = 1; i < argc; i++)
	{
		if(sscanf(argv[i], "%d", &part) == 1)
			continue;

		fd = open(argv[i], 0, 0);
		if (fd >= 0)
		{
			ioctl(fd, RAID_AUTORUN, part);
			close(fd);
		} else
		{
			printf("Error: Failed to open %s!\n", argv[i]);
			retval=1;
		}

		part = 0;
	}

	return retval;
}
