#include <sys/types.h>
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <asm/unistd.h>

extern char *modules_devfs;

#define create_module(name, size) \
        syscall(__NR_create_module, (name), (size))

/* returns true if we have a 2.5.48+ kernel */
int check_kernel_version (int verbose)
{
	int k25 = 1;

	errno = 0;
	if (create_module(NULL, 0) >= 0 /* Uh oh, what have I just done? */
	    || errno != ENOSYS)
		k25 = 0;

	if (verbose)
		fprintf (stderr, "devfsd: kernel %s detected\n",
				k25 ? "2.5.48+" : "2.4");

	return k25;
}

void update_config_file (int verbose)
{
	int k25 = check_kernel_version (verbose);
	
	if (k25)
		modules_devfs = "/etc/modules.devfs";

	if (verbose)
		fprintf (stderr, "devfsd: using %s for MODLOAD\n", modules_devfs);
}

